
#include <map>
#include <unordered_map>
#include <boost/algorithm/string.hpp>
#include <vector>
#include <mutex>
#include <chrono>
#include <iostream>
#include <fstream>
#include "ThreadPool.h"
#include "evidence.hpp"
#include "external.hpp"
#include "functions.hpp"


using namespace std;

void check_hard_filter()
{
    
    int count = 0;
    int notpass = 0;
    
    
    v_vcf = v_input;
    v_out = v_output;
    
    string v_log = v_out + ".log";
    
    ofstream out;
    out.open (v_out);
    out.close();
    out.open(v_out, std::ios_base::app);

    ofstream log;
    log.open (v_log);
    log.close();
    log.open(v_log, std::ios_base::app);

    
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::hfilter" , 1, v_quiet);
    screen_message (screen_size, 2, "Loading and processing ...", 2, v_quiet);
    vector <string> head;
    
    string line;
    ifstream myfile (v_vcf);

    int filter_index = 0;
    int info_index = 0;

    while ( getline (myfile,line) )
    {
        if (line.substr(0,2) == "##") {out << line << endl;continue;}
        if (line.substr(0,2) == "#C")
        {
            
             out << "##FILTER=<ID=PASS,Description=\"Passing filter\">" << endl;
            
            out << line << endl;
            vector <string> data;
            boost::split(data,line,boost::is_any_of("\t"));
            int vindex = 0;
            for(auto &&item: data)
            {
                if (item == "FILTER") {filter_index = vindex;}
                if (item == "INFO") {info_index = vindex;}
                vindex++;
            }
            continue;
        }
     
        if (line == "") {continue;}
     
        vector <string> check;
        boost::split(check,line,boost::is_any_of("\t"));

        int start_int = 0;
        if (vstart != "0")
        {
            try {
                start_int = stoi(vstart);
            }
            catch (const std::exception& e) {
                start_int = 0;
            }
        }
     
        int end_int = 0;
        if (vend != "0")
        {
            try {
                end_int = stoi(vend);
            }
            catch (const std::exception& e) {
                end_int = 0;
            }
        }
     
     
        if (v_chr != "")
        {
            if (v_chr != check[0]){continue;}
        }
        if (start_int > 0)
        {
            if (stoi(check[1]) < start_int){continue;}
        }
        if (end_int > 0)
        {
            if (stoi(check[1]) > end_int) {break;}
        }

        string v_snp = check[0] + "\t" + check[1] + "\t" + check[2] + "\t" + check[3] + "\t" + check[4];
        
        int reject = 0;

        vector <string> info_data;
        boost::split(info_data,check[info_index],boost::is_any_of(";"));

        string fail = "";
        
        for(auto &&item: info_data)
        {
            vector <string> info_data_split;
            boost::split(info_data_split,item,boost::is_any_of("="));
            if (info_data_split[0] == "QD")
            {
                float qd_value = stof(info_data_split[1]);
                if (qd_value < v_qd) {reject++; fail.append(",QD");}
            }
            
            if (info_data_split[0] == "FS")
            {
                float fs_value = stof(info_data_split[1]);
                if (fs_value > v_fs) {reject++; fail.append(",FS");}
            }

            if (info_data_split[0] == "SOR")
            {
                float sor_value = stof(info_data_split[1]);
                if (sor_value > v_sor) {reject++; fail.append(",SOR");}
            }

            if (info_data_split[0] == "MQ")
            {
                float mq_value = stof(info_data_split[1]);
                if (mq_value < v_mq) {reject++; fail.append(",MQ");}
            }
         
            if (info_data_split[0] == "MQRankSum")
            {
                float MQRankSum_value = stof(info_data_split[1]);
                if ((MQRankSum_value < v_mqr_min) || (MQRankSum_value > v_mqr_max)) {reject++; fail.append(",MQRankSum");}
            }

            if (info_data_split[0] == "ReadPosRankSum")
            {
                float ReadPosRankSum_value = stof(info_data_split[1]);
                if ((ReadPosRankSum_value < v_rprs_min) || (ReadPosRankSum_value > v_rprs_max))   {reject++; fail.append(",ReadPosRankSum");}
            }
        }
        
        
        
        if (reject == 0)
        {
            check[filter_index] = "PASS";
            out << check[0];
            for (int a = 1; a < check.size(); a++)
            {
                out << "\t" << check[a];
            }
            out << endl;
            count++;
            continue;
        }
        else
        {
            log << v_snp << "\t" << fail.substr(1) << endl;
            out << line << endl;
            notpass++;
        }
     
    }
    myfile.close();

    float ratio = (float(count) / float(count + notpass)) * float(100);
    screen_message (screen_size, 2, "Loading and processing ... done", 1, v_quiet);
    screen_message (screen_size, 2, "Number of variants passing hard-filtering: " + to_string(count) + " (" + to_string(ratio) + " %)", 1, v_quiet);
    screen_message (screen_size, 2, "Output file: " + v_output, 1, v_quiet);
    out.close();
    log.close();

}


void help_hard_filter ()
{
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::hfilter" , 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "* Author  : " + Program_author, 1, 0);
    screen_message (screen_size, 2, "* Contact : " + Program_contact, 1, 0);
    screen_message (screen_size, 2, "* Version : " + Program_version, 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "Options", 1, 0);
    screen_message (screen_size, 5, "input      the input VCF file [mandatory]", 1, 0);
    screen_message (screen_size, 5, "output     the VCF file to be created", 1, 0);
    screen_message (screen_size, 5, "chr        the chromosome to be considered", 1, 0);
    screen_message (screen_size, 5, "start      start processing from this position", 1, 0);
    screen_message (screen_size, 5, "end        process variants to this position", 1, 0);
    screen_message (screen_size, 5, "QD         QualByDepth threshold [default: " + to_string(v_qd) + "]", 1, 0);
    screen_message (screen_size, 5, "FS         FisherStrand [default: " + to_string(v_fs) + "]", 1, 0);
    screen_message (screen_size, 5, "SOR        StrandOddsRatio [default: " + to_string(v_sor) + "]", 1, 0);
    screen_message (screen_size, 5, "MQ         RMSMappingQuality [default: " + to_string(v_mq) + "]", 1, 0);
    screen_message (screen_size, 5, "MQR_min    MQRankSum/MappingQualityRankSumTest [default: " + to_string(v_mqr_min) + "]", 1, 0);
    screen_message (screen_size, 5, "MQR_max    MQRankSum/MappingQualityRankSumTest [default: " + to_string(v_mqr_max) + "]", 1, 0);
    screen_message (screen_size, 5, "RPRS_min   ReadPosRankSumTest [default: " + to_string(v_rprs_min) + "]", 1, 0);
    screen_message (screen_size, 5, "RPRS_max   ReadPosRankSumTest [default: " + to_string(v_rprs_max) + "]", 1, 0);


    screen_message (screen_size, 5, "--quiet    quiet mode", 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    PrintWarnings();
    return;
}

void main_hard_filter ()
{
    if (! fileExists(v_input)) {warnings.push_back("The input file could not be found.");help_hard_filter();return;}
    if (v_output == "") {v_output = GetFileNameWithoutExtension (v_input) + ".hfilter.vcf";}
    check_hard_filter();
    return;
}

