
#include <map>
#include <unordered_map>
#include <boost/algorithm/string.hpp>
#include <vector>
#include <mutex>
#include <chrono>
#include <iostream>
#include <fstream>
#include "ThreadPool.h"
#include "evidence.hpp"
#include "external.hpp"
#include "functions.hpp"

using namespace std;

void check_genepop()
{
    
    v_vcf = v_input;
    v_out = v_output;
    
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::genepop" , 1, v_quiet);
    screen_message (screen_size, 2, "Loading data ...", 2, v_quiet);
    
    vector<string> head;
    vector<string> subdata;
    vector<string> genotypes;
    vector<string> positions;
    std::map <pair<string,string>, string> snp_data;
    std::map <string,int> samples;
    
    int head_start = 0;
    int sample_size = 0;
    int snps = 0;
    
    ifstream input( v_vcf );
    for( std::string line; getline( input, line ); )
    {
        if (line.substr(0,2) == "##"){continue;}
        if (line.substr(0,4) == "#CHR")
        {
            boost::split(head,line,boost::is_any_of("\t"));
            for(vector<string>::iterator sample = head.begin();sample!=head.end();++sample)
            {
                sample_size++;
                if (*sample == "FORMAT"){head_start = sample_size;}
            }
            continue;
        }
        
        boost::split(subdata,line,boost::is_any_of("\t"));
 
        int start_int = 0;
        if (vstart != "0")
        {
            try {
                start_int = stoi(vstart);
            }
            catch (const std::exception& e) {
                start_int = 0;
            }
        }
        
        int end_int = 0;
        if (vend != "0")
        {
            try {
                end_int = stoi(vend);
            }
            catch (const std::exception& e) {
                end_int = 0;
            }
        }
        
        
        if (v_chr != "")
        {
            if (v_chr != subdata[0]){continue;}
        }
        if (start_int > 0)
        {
            if (stoi(subdata[1]) < start_int){continue;}
        }
        if (end_int > 0)
        {
            if (stoi(subdata[1]) > end_int) {break;}
        }
        
        
        
        if ((subdata[0] != v_chr) && (v_chr != "")){continue;}
        if ((stoi(subdata[1]) < stoi(vstart)) && (vstart != "0")) {continue;}
        if ((stoi(subdata[1]) > stoi(vend) ) && (vend != "0")) {continue;}
        
        snps++;
        positions.push_back (subdata[1]);
        
        for (int a = head_start; a < sample_size; a++)
        {
            boost::split(genotypes,subdata[a],boost::is_any_of(":"));
            
            
            pair <string,string> key = make_pair(head[a],subdata[1]);
            snp_data[key] = genotypes[0];
            
        }
    }
    input.close();
    
    
    if (head_start == 0) { warnings.push_back("This VCF file does not have a FORMAT field. Please check the VCF file"); return;}
    if (snps == 0) { warnings.push_back("No data following these parameters"); return;}
    
    
    for (int a = head_start; a < sample_size; a++)
    {
        samples[head[a]] = 1;
    }
    screen_message (screen_size, 2, "Loading data ... done", 1, v_quiet);
    screen_message (screen_size, 2, "Printing file ... ", 2, v_quiet);

    
    
    
    if (v_pop == "") {
        
        
        ofstream myfile;
        myfile.open (v_output);
        
        myfile << "Title" << endl;
        
        for (auto & pos : positions)
        {
            myfile << pos << endl;
        }
        myfile << "pop" << endl;
        
        
        
        vector<string> helper;
        for (int a = head_start; a < sample_size; a++)
        {
            myfile << head[a] << ", ";
            string line1;
            for(vector<string>::iterator pos = positions.begin();pos!=positions.end();++pos)
            {
                pair <string,string> key = make_pair(head[a],*pos);
                string gen = snp_data[key];
                if (gen == ".") {gen = "./.";}
                std::replace( gen.begin(), gen.end(), '|', '/'); // replace all '|' to '/'
                boost::split(helper,gen,boost::is_any_of("/"));
                
                string genotype = "";
                
                if (helper[0] == ".") {genotype = "000";}
                if (helper[0] != ".")
                {
                    int check = stoi(helper[0]);
                    check++;
                    genotype  = "00" + to_string(check);
                }
                
                if (helper[1] == ".") {genotype.append("000");}
                if (helper[1] != ".")
                {
                    int check = stoi(helper[1]);
                    check++;
                    genotype.append("00" + to_string(check));
                }
                
                line1.append (" " + genotype);
                
            }
            
            myfile << line1 << endl;
            
            
        }
        myfile.close();
    }
    
    
    
    if (v_pop != "") {
        
        vector<string> pop_data;
        std::map <string, string> pop;
        
        ifstream input( v_pop );
        for( std::string line; getline( input, line ); )
        {
            boost::split(pop_data,line,boost::is_any_of(","));
            if (pop[pop_data[1]] == "") {pop[pop_data[1]] = pop_data[0];}
            else {pop[pop_data[1]] = pop[pop_data[1]] + "," + pop_data[0];}
        }
        input.close();
        
        int pop_number = 0;
        std::map <string, int> pop_size;
        vector<string> helper;
        
        for (std::map<string, string>::iterator i = pop.begin(); i != pop.end(); ++i)
        {
            pop_number++;
            
            boost::split(helper,pop[i->first],boost::is_any_of(","));
            for(vector<string>::iterator sample_id = helper.begin();sample_id!=helper.end();++sample_id)
            {
                if (samples[*sample_id] == 1) {pop_size[i->first]++;}
            }
            
        }
        
        
        
        ofstream myfile;
        myfile.open (v_output);
        
        myfile << "Title" << endl;
        
        for (auto & pos : positions)
        {
            myfile << pos << endl;
        }
        
        for (std::map<string, string>::iterator i = pop.begin(); i != pop.end(); ++i)
        {
            myfile << "pop" << endl;
            
            boost::split(helper,pop[i->first],boost::is_any_of(","));
            
            for(vector<string>::iterator sample_id = helper.begin();sample_id!=helper.end();++sample_id)
            {
                
                if (samples[*sample_id] == 1)
                {
                    
                    myfile << *sample_id << ", ";
                    string line1;
 
                    for(vector<string>::iterator pos = positions.begin();pos!=positions.end();++pos)
                    {
                        pair <string,string> key = make_pair(*sample_id,*pos);
                        string gen = snp_data[key];
                        std::replace( gen.begin(), gen.end(), '|', '/'); // replace all '|' to '/'
                        vector<string> helper;
                        
                        boost::split(helper,gen,boost::is_any_of("/"));
                        
                        
                        string genotype = "";
                         
                         if (helper[0] == ".") {genotype = "000";}
                         if (helper[0] != ".")
                         {
                             int check = stoi(helper[0]);
                             check++;
                             genotype  = "00" + to_string(check);
                         }
                         
                         if (helper[1] == ".") {genotype.append("000");}
                         if (helper[1] != ".")
                         {
                             int check = stoi(helper[1]);
                             check++;
                             genotype.append("00" + to_string(check));
                         }
                         
                         line1.append (" " + genotype);
                        
                    }
                    
                    
                    myfile << line1 << endl;
                }
                
            }
        }
    }
    
    screen_message (screen_size, 2, "Printing genepop file ... done", 1, v_quiet);
    screen_message (screen_size, 5, "", 1, v_quiet);
    return;
    
    
}


void help_genepop ()
{
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::genepop" , 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "* Author  : " + Program_author, 1, 0);
    screen_message (screen_size, 2, "* Contact : " + Program_contact, 1, 0);
    screen_message (screen_size, 2, "* Version : " + Program_version, 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "Options", 1, 0);
    screen_message (screen_size, 5, "input      the input VCF file [mandatory]", 1, 0);
    screen_message (screen_size, 5, "output     the output file to be created", 1, 0);
    screen_message (screen_size, 5, "chr        the chromosome to be considered", 1, 0);
    screen_message (screen_size, 5, "start      start processing from this position", 1, 0);
    screen_message (screen_size, 5, "end        process variants to this position", 1, 0);
    screen_message (screen_size, 5, "pop        file with sample definition, one per line. E.g. HG000096,CEU", 1, 0);
    screen_message (screen_size, 5, "--quiet    quiet mode", 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    PrintWarnings();
    return;
}

void main_genepop ()
{
    if (! fileExists(v_input)) {warnings.push_back("The input file could not be found.");help_genepop();return;}
    if (v_pop != "") {if(! fileExists(v_pop)) {warnings.push_back("The POP file could not be found.");help_genepop();return;}}
    if (v_output == "") {v_output = GetFileNameWithoutExtension (v_input) + ".genepop.txt";}
    check_genepop();
    return;
}
