
#include <map>
#include <unordered_map>
#include <boost/algorithm/string.hpp>
#include <vector>
#include <mutex>
#include <chrono>
#include <iostream>
#include <fstream>
#include "ThreadPool.h"
#include "evidence.hpp"
#include "external.hpp"
#include "functions.hpp"

using namespace std;

void check_filter()
{
    
    int count = 0;
    
    vector <string> filters;
    boost::split(filters,tag,boost::is_any_of(","));
    if (filters.size() == 0) {warnings.push_back("You must indicate at least one TAG to keep"); return;}
    
    v_vcf = v_input;
    v_out = v_output;
    
    ofstream out;
    out.open (v_out);
    out.close();
    out.open(v_out, std::ios_base::app);
    


    
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::filter" , 1, v_quiet);
    screen_message (screen_size, 2, "Loading and processing ...", 2, v_quiet);
    vector <string> head;
    
    string line;
    ifstream myfile (v_vcf);

    int filter_index = 0;

    while ( getline (myfile,line) )
    {
        if (line.substr(0,2) == "##") {out << line << endl;continue;}
        if (line.substr(0,2) == "#C")
        {
            out << line << endl;
            vector <string> data;
            boost::split(data,line,boost::is_any_of("\t"));
            int vindex = 0;
            for(auto &&item: data)
            {
                if (item == "FILTER") {filter_index = vindex;}
                vindex++;
            }
            continue;
        }
     
        if (line == "") {continue;}
     
        vector <string> check;
        boost::split(check,line,boost::is_any_of("\t"));

        int start_int = 0;
        if (vstart != "0")
        {
            try {
                start_int = stoi(vstart);
            }
            catch (const std::exception& e) {
                start_int = 0;
            }
        }
     
        int end_int = 0;
        if (vend != "0")
        {
            try {
                end_int = stoi(vend);
            }
            catch (const std::exception& e) {
                end_int = 0;
            }
        }
     
     
        if (v_chr != "")
        {
            if (v_chr != check[0]){continue;}
        }
        if (start_int > 0)
        {
            if (stoi(check[1]) < start_int){continue;}
        }
        if (end_int > 0)
        {
            if (stoi(check[1]) > end_int) {break;}
        }

        int accept = 0;
        for(auto &&item: filters)
        {
            if (item == check[filter_index]) {accept = 1;}
        }
        
        if (accept == 1)
        {
            out << line << endl;
            count++;
        }
     
    }
    myfile.close();


    screen_message (screen_size, 2, "Loading and processing ... done", 1, v_quiet);
    screen_message (screen_size, 2, "Number of kept variants: " + to_string(count), 1, v_quiet);
    screen_message (screen_size, 2, "Output file: " + v_output, 1, v_quiet);
    out.close();
    
}


void help_filter ()
{
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::filter" , 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "* Author  : " + Program_author, 1, 0);
    screen_message (screen_size, 2, "* Contact : " + Program_contact, 1, 0);
    screen_message (screen_size, 2, "* Version : " + Program_version, 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "Options", 1, 0);
    screen_message (screen_size, 5, "input      the input VCF file [mandatory]", 1, 0);
    screen_message (screen_size, 5, "output     the VCF file to be created", 1, 0);
    screen_message (screen_size, 5, "tag        PASS (default: PASS)", 1, 0);
    screen_message (screen_size, 5, "chr        the chromosome to be considered", 1, 0);
    screen_message (screen_size, 5, "start      start processing from this position", 1, 0);
    screen_message (screen_size, 5, "end        process variants to this position", 1, 0);
    screen_message (screen_size, 5, "--quiet    quiet mode", 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    PrintWarnings();
    return;
}

void main_filter ()
{
    if (! fileExists(v_input)) {warnings.push_back("The input file could not be found.");help_filter();return;}
    if (v_output == "") {v_output = GetFileNameWithoutExtension (v_input) + ".filter.vcf";}
    check_filter();
    return;
}
